document.addEventListener('DOMContentLoaded', () => {

    // --- CONFIGURATION ---
    const CONFIG = {
        // Ganti dengan nomor WhatsApp admin lo (format internasional tanpa + atau 00)
        adminWhatsAppNumber: '6281234567890',

        // Nomor WhatsApp khusus untuk menerima testimoni
        testimonialWhatsAppNumber: '6282129292808',

        // URL Google Form kamu yang sudah benar
        googleFormUrl: 'https://docs.google.com/forms/d/e/1FAIpQLScDTU5WoIPa7xr4xB0ygs22pX1H1le8qxPZotyjs1jhb-DiiA/formResponse',

        // URL Google Form untuk testimoni (buat form baru khusus testimoni)
        testimonialGoogleFormUrl: 'GANTI_DENGAN_URL_FORM_TESTIMONI_KAMU/formResponse',

        // ID Entri dari setiap pertanyaan di form kamu (SESUAI DENGAN FORMAT LAMA)
        googleFormEntry: {
            customerName: 'entry.2035066601',
            customerAddress: 'entry.1139456435',
            customerPhone: 'entry.517068978',
            invoiceNumber: 'entry.1942725401',
            donutName: 'entry.1511787868',
            donutQty: 'entry.1496448308',
            donutPrice: 'entry.953349753',
            donutTotal: 'entry.1224114893',
            finalTotal: 'entry.2121494390',
            orderNotes: 'entry.1492742951', // ID untuk Keterangan sudah terisi

            // --- Entri untuk Form Testimoni ---
            testiName: 'GANTI_DENGAN_ID_ENTRY_NAMA_TESTI',
            testiOrderTime: 'GANTI_DENGAN_ID_ENTRY_WAKTU_ORDER_TESTI',
            testiMessage: 'GANTI_DENGAN_ID_ENTRY_PESAN_TESTI'
        }
    };

    // --- HELPER UNTUK DATA PRODUK ---
    const classicImages = Array.from({ length: 4 }, (_, i) => `images/section-2-classic/donat-classic-${i + 1}.jpg`);
    const toppingImages = Array.from({ length: 16 }, (_, i) => `images/section-3-toping/donat-toping-${i + 1}.jpg`);
    const bomboloniImages = Array.from({ length: 5 }, (_, i) => `images/section-4-bomboloni/bomboloni-${i + 1}.jpg`);
    const toppingVariations = [
        { name: "Dancow", priceModifier: 0 }, { name: "Dark Coklat", priceModifier: 0 },
        { name: "Coco Crunch", priceModifier: 0 }, { name: "White Almond", priceModifier: 0 },
        { name: "Tiramisu", priceModifier: 0 }, { name: "Green Tea", priceModifier: 0 },
        { name: "Cappucino", priceModifier: 0 }, { name: "Choco Strawberry", priceModifier: 0 },
        { name: "Red Velvet", priceModifier: 0 }, { name: "Rainbow Choco", priceModifier: 0 },
        { name: "Peanut", priceModifier: 0 }, { name: "Vanilla White", priceModifier: 0 },
        { name: "Taro", priceModifier: 0 }, { name: "Mango", priceModifier: 0 },
        { name: "Avocado", priceModifier: 0 }, { name: "Blue Berry", priceModifier: 0 },
        { name: "Oreo", priceModifier: 0 }, { name: "Caramel Dulce", priceModifier: 0 },
        { name: "Palm Sugar", priceModifier: 0 }, { name: "Dusting", priceModifier: 0 },
        { name: "Meses", priceModifier: 0 }, { name: "Cheese", priceModifier: 0 }
    ];
    const bomboloniVariations = [
        { name: "Cream Cheese", priceModifier: 0 }, { name: "Green Tea", priceModifier: 0 },
        { name: "Tiramisu", priceModifier: 0 }, { name: "Lemon", priceModifier: 0 },
        { name: "Coklat", priceModifier: 0 }, { name: "Selai Strawberry", priceModifier: 0 },
        { name: "Taro", priceModifier: 0 }, { name: "Red Velvet", priceModifier: 0 }
    ];

    // --- PRODUCT DATA ---
    const products = [
        {
            id: 1,
            name: 'Donat Jadoel',
            section: 1,
            suffix: '3 Pcs',
            price: 10000,
            image: 'images/section-1-jadoel/donat-jadoel-1.jpg',
            slideshowImages: [
                'images/section-1-jadoel/donat-jadoel-1.jpg',
                'images/section-1-jadoel/donat-jadoel-2.jpg',
                'images/section-1-jadoel/donat-jadoel-3.jpg',
                'images/section-1-jadoel/donat-jadoel-4.jpg',
                'images/section-1-jadoel/donat-jadoel-5.jpg'
            ],
            variations: [
                { name: "Gula Putih", priceModifier: 0 },
                { name: "Gula Palm", priceModifier: 0 },
                { name: "Mix (Gula Putih & Palm)", priceModifier: 0 }
            ]
        },
        {
            id: 2,
            name: 'Donat Jadoel',
            section: 1,
            suffix: '6 Pcs',
            price: 15000,
            image: 'images/section-1-jadoel/donat-jadoel-1.jpg',
            slideshowImages: [
                'images/section-1-jadoel/donat-jadoel-1.jpg',
                'images/section-1-jadoel/donat-jadoel-2.jpg',
                'images/section-1-jadoel/donat-jadoel-3.jpg',
                'images/section-1-jadoel/donat-jadoel-4.jpg',
                'images/section-1-jadoel/donat-jadoel-5.jpg'
            ],
            variations: [
                { name: "Gula Putih", priceModifier: 0 },
                { name: "Gula Palm", priceModifier: 0 },
                { name: "Mix (Gula Putih & Palm)", priceModifier: 0 }
            ]
        },
        {
            id: 3,
            name: 'Donat Jadoel',
            section: 1,
            suffix: '12 Pcs',
            price: 30000,
            image: 'images/section-1-jadoel/donat-jadoel-1.jpg',
            slideshowImages: [
                'images/section-1-jadoel/donat-jadoel-1.jpg',
                'images/section-1-jadoel/donat-jadoel-2.jpg',
                'images/section-1-jadoel/donat-jadoel-3.jpg',
                'images/section-1-jadoel/donat-jadoel-4.jpg',
                'images/section-1-jadoel/donat-jadoel-5.jpg'
            ],
            variations: [
                { name: "Gula Putih", priceModifier: 0 },
                { name: "Gula Palm", priceModifier: 0 },
                { name: "Mix (Gula Putih & Palm)", priceModifier: 0 }
            ]
        },
        // --- SECTION 2 (Classic) ---
        {
            id: 4,
            name: 'Donat Classic',
            section: 2,
            suffix: '3 Pcs',
            price: 10000,
            image: 'images/section-2-classic/donat-classic-1.jpg',
            slideshowImages: classicImages,
            variations: [
                { name: "Kacang", priceModifier: 0 },
                { name: "Oreo", priceModifier: 0 },
                { name: "Meses", priceModifier: 0 },
                { name: "Keju", priceModifier: 0 },
                { name: "Mix", priceModifier: 0 }
            ]
        },
        {
            id: 5,
            name: 'Donat Classic',
            section: 2,
            suffix: '6 Pcs',
            price: 17500,
            image: 'images/section-2-classic/donat-classic-2.jpg',
            slideshowImages: classicImages,
            variations: [
                { name: "Kacang", priceModifier: 0 },
                { name: "Oreo", priceModifier: 0 },
                { name: "Meses", priceModifier: 0 },
                { name: "Keju", priceModifier: 0 },
                { name: "Mix", priceModifier: 0 }
            ]
        },
        {
            id: 6,
            name: 'Donat Classic',
            section: 2,
            suffix: '12 Pcs',
            price: 35000,
            image: 'images/section-2-classic/donat-classic-3.jpg',
            slideshowImages: classicImages,
            variations: [
                { name: "Kacang", priceModifier: 0 },
                { name: "Oreo", priceModifier: 0 },
                { name: "Meses", priceModifier: 0 },
                { name: "Keju", priceModifier: 0 },
                { name: "Mix", priceModifier: 0 }
            ]
        },
        // --- SECTION 3 (Topping) ---
        {
            id: 7, name: 'Donat Topping', suffix: '3 Pcs', price: 15000, section: 3,
            image: toppingImages[0], slideshowImages: toppingImages,
            variationType: 'multi-select-qty',
            maxVariationQty: 3,
            variations: toppingVariations
        },
        {
            id: 8, name: 'Donat Topping', suffix: '6 Pcs', price: 20000, section: 3,
            image: toppingImages[0], slideshowImages: toppingImages,
            variationType: 'multi-select-qty',
            maxVariationQty: 6,
            variations: toppingVariations
        },
        {
            id: 9, name: 'Donat Topping', suffix: '12 Pcs', price: 40000, section: 3,
            image: toppingImages[0], slideshowImages: toppingImages,
            variationType: 'multi-select-qty',
            maxVariationQty: 12,
            variations: toppingVariations
        },
        {
            id: 10,
            name: 'Papan Coklat',
            suffix: 'HBD',
            section: 3,
            price: 10000,
            image: 'images/papan-coklat-hbd/papan-coklat-hbd.jpg',
            customAction: {
                text: 'Tambahkan',
                class: 'btn-custom-pink'
            }
        },
        // --- SECTION 4 (Bomboloni) ---
        {
            id: 11,
            name: 'Donat Bomboloni',
            section: 4,
            suffix: '6 Pcs',
            price: 35000,
            variationType: 'multi-select-qty', // Flag untuk logika variasi baru
            maxVariationQty: 6,                // Jumlah maksimal variasi yang bisa dipilih
            image: bomboloniImages[0],
            slideshowImages: bomboloniImages,
            variations: bomboloniVariations
        }
    ];

    // --- STATE MANAGEMENT ---
    let cart = JSON.parse(localStorage.getItem('shoppingCart')) || [];
    let testimonials = JSON.parse(localStorage.getItem('testimonials')) || [];

    // --- DOM ELEMENTS ---
    const pages = {
        katalog: document.getElementById('katalog-page'),
        cart: document.getElementById('cart-page'),
        checkout: document.getElementById('checkout-page'),
        invoice: document.getElementById('invoice-page')
    };

    const testimonialTickerContainer = document.getElementById('testimonial-ticker-container');
    const testimonialTickerText = document.getElementById('testimonial-ticker-text');
    const gallerySection = document.getElementById('gallery-section');
    const productList1 = document.getElementById('product-list-1');
    const productList2 = document.getElementById('product-list-2');
    const productList3 = document.getElementById('product-list-3');
    const productList4 = document.getElementById('product-list-4');
    const floatingCart = document.getElementById('floating-cart');
    const cartBadge = document.getElementById('cart-badge');
    const floatingCartLink = document.getElementById('floating-cart-link');

    const cartItemsContainer = document.getElementById('cart-items-container');
    const cartTotalEl = document.getElementById('cart-total');

    const checkoutButton = document.getElementById('checkout-button');
    const backToKatalogButton = document.getElementById('back-to-katalog');
    const backToCartButton = document.getElementById('back-to-cart');
    const checkoutForm = document.getElementById('checkout-form');
    const testimonialForm = document.getElementById('testimonial-form');
    const submitButton = checkoutForm.querySelector('button[type="submit"]');

    const variationModal = document.getElementById('variation-modal');
    const modalProductName = document.getElementById('modal-product-name');
    const modalVariationsContainer = document.getElementById('modal-variations-container');
    let modalAddToCartBtn = document.getElementById('modal-add-to-cart-btn');

    const multiVariationModal = document.getElementById('multi-variation-modal');
    const multiModalProductName = document.getElementById('multi-modal-product-name');
    const multiModalVariationsContainer = document.getElementById('multi-modal-variations-container');
    const multiModalSubtitle = document.getElementById('multi-modal-subtitle');
    const multiModalCurrentQty = document.getElementById('multi-modal-current-qty');
    const multiModalMaxQty = document.getElementById('multi-modal-max-qty');
    let multiModalAddToCartBtn = document.getElementById('multi-modal-add-to-cart-btn');

    const imageModal = document.getElementById('image-modal');
    const galleryModal = document.getElementById('gallery-modal');
    let galleryModalContainer;
    let galleryModalCloseBtn;
    let galleryModalPrevBtn;
    let galleryModalNextBtn;
    let galleryModalDotsContainer;

    const imageModalSrc = document.getElementById('image-modal-src');

    const shareModal = document.getElementById('share-modal');
    const shareImageBtn = document.getElementById('share-image-btn');
    const sharePdfBtn = document.getElementById('share-pdf-btn');
    const shareWhatsappBtn = document.getElementById('share-whatsapp-btn');
    const shareModalLoading = document.getElementById('share-modal-loading');

    const messageContainer = document.createElement('div');
    messageContainer.style.textAlign = 'center';
    messageContainer.style.marginTop = '1rem';
    checkoutForm.parentNode.insertBefore(messageContainer, checkoutForm.nextSibling);

    // --- SLIDESHOW STATE & ELEMENTS ---
    let currentSlideIndex = 0;
    let slides = [];
    let slideshowTrack; // Definisikan di scope yang lebih luas
    let dots = [];
    let slideInterval;
    const SLIDESHOW_IMAGE_COUNT = 14;

    // State untuk drag/swipe
    let isDragging = false;
    let startPos = 0;
    let currentTranslate = 0;
    let prevTranslate = 0;

    // State untuk data invoice yang akan di-share
    let currentInvoiceDataForSharing = {};

    // --- GALLERY MODAL STATE ---
    let galleryModalSlides = [];
    let galleryModalDots = [];
    let galleryModalTrack;
    let galleryModalCurrentIndex = 0;
    let galleryModalIsDragging = false;
    let galleryModalStartPos = 0;
    let galleryModalCurrentTranslate = 0;
    let galleryModalPrevTranslate = 0;


    // --- HELPER FUNCTIONS ---
    /**
     * Mengacak urutan elemen dalam sebuah array (Fisher-Yates shuffle).
     * @param {Array} array - Array yang akan diacak.
     * @returns {Array} Array baru dengan urutan acak.
     */
    const shuffleArray = (array) => {
        const newArray = [...array]; // Buat salinan agar tidak mengubah array asli
        for (let i = newArray.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [newArray[i], newArray[j]] = [newArray[j], newArray[i]];
        }
        return newArray;
    };

    /**
     * Menghasilkan nama tampilan produk, dengan atau tanpa HTML badge.
     * @param {object} item - Objek produk atau item keranjang. Harus memiliki properti 'name' dan bisa memiliki 'suffix'.
     * @param {boolean} withHtml - Jika true, akan menghasilkan nama dengan tag span untuk badge.
     * @returns {string} Nama tampilan produk.
     */
    const getDisplayName = (item, withHtml = true) => {
        let baseName = item.name;
        let variationPart = '';

        // Pisahkan nama dasar dari variasi jika ada (misal: "Donat (Cokelat)")
        const variationMatch = baseName.match(/(.*)(\s\(.*\))$/);
        if (variationMatch) {
            baseName = variationMatch[1];
            variationPart = variationMatch[2];
        }

        const suffix = item.suffix || '';
        const mixSummary = item.mixSummary || ''; // Ambil ringkasan mix

        // Gabungkan nama dasar dengan suffix (jika ada)
        let nameWithSuffix = baseName;
        if (suffix) {
            nameWithSuffix = withHtml
                ? `${baseName} <span class="pcs-badge">${suffix}</span>`
                : `${baseName} ${suffix}`;
        }

        // Jika tidak ada suffix dan tidak ada mix, kembalikan nama asli
        if (!suffix && !mixSummary) return item.name;

        return `${nameWithSuffix}${variationPart} ${mixSummary}`.trim();
    };

    // --- FUNCTIONS ---
    const formatPrice = (price) => {
        return new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR', minimumFractionDigits: 0 }).format(price);
    };

    const showPage = (pageName) => {
        Object.values(pages).forEach(page => page.classList.add('hidden'));
        if (pages[pageName]) {
            pages[pageName].classList.remove('hidden');
        }
        window.scrollTo(0, 0);
    };

    const renderTestimonialTicker = () => {
        if (!testimonialTickerContainer || !testimonialTickerText || testimonials.length === 0) {
            testimonialTickerContainer.classList.add('hidden');
            return;
        }

        const tickerContent = testimonials.map(t => `"${t.message}" - ${t.name}`).join(' ••• ');
        testimonialTickerText.textContent = tickerContent;
        
        // Atur durasi animasi berdasarkan panjang teks
        testimonialTickerText.style.animationDuration = `${testimonials.length * 15}s`;
        testimonialTickerContainer.classList.remove('hidden');
    };

    const saveCart = () => {
        localStorage.setItem('shoppingCart', JSON.stringify(cart));
        updateFloatingCart();
    };

    const updateFloatingCart = () => {
        const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
        // Selalu pastikan ikon keranjang utama terlihat
        floatingCart.classList.remove('hidden');

        if (totalItems > 0) {
            cartBadge.textContent = totalItems;
            cartBadge.classList.remove('hidden');
        } else {
            // Jika keranjang kosong, sembunyikan badge angka saja
            cartBadge.classList.add('hidden');
        }
    };

    const addToCart = (productId, selectedVariation = null) => {
        const originalProduct = products.find(p => p.id === productId);
        if (!originalProduct) return;

        let productForCart = { ...originalProduct };
        let cartId;

        // Logika baru untuk variasi multi-pilih (rakit kotak)
        if (productForCart.variationType === 'multi-select-qty' && Array.isArray(selectedVariation)) {
            const variationSummary = selectedVariation.map(v => `${v.quantity} ${v.name}`).join(', ');
            productForCart.mixSummary = `(Mix: ${variationSummary})`; // Properti baru untuk ringkasan
            
            // Buat ID unik untuk campuran ini agar tidak tergabung dengan kotak lain
            const mixId = selectedVariation.map(v => `${v.quantity}${v.name.replace(/\s/g, '')}`).join('-');
            cartId = `${productForCart.id}-${mixId}`;

        // Logika lama untuk variasi tunggal
        } else if (selectedVariation && !Array.isArray(selectedVariation)) {
            productForCart.name = `${originalProduct.name} (${selectedVariation.name})`;
            productForCart.price += selectedVariation.priceModifier;
            cartId = `${productForCart.id}-${selectedVariation.name.replace(/\s/g, '-')}`;
        
        // Logika untuk produk simpel tanpa variasi
        } else {
            cartId = productForCart.id;
        }

        const cartItem = cart.find(item => item.cartId === cartId);
        if (cartItem) {
            cartItem.quantity++;
        } else {
            // Pastikan hanya properti yang relevan yang masuk ke keranjang
            const { variations, variationType, maxVariationQty, ...restOfProduct } = productForCart;
            cart.push({ ...restOfProduct, quantity: 1, cartId: cartId });
        }
        saveCart();
        console.log(`Produk dengan cartId: ${cartId} telah ditambahkan ke keranjang!`);

        // Visual feedback: Shake the cart icon
        floatingCart.classList.add('shake');
        setTimeout(() => {
            floatingCart.classList.remove('shake');
        }, 820); // Sesuaikan dengan durasi animasi
    };

    const renderProducts = () => {
        productList1.innerHTML = '';
        productList2.innerHTML = '';
        productList3.innerHTML = '';
        productList4.innerHTML = '';
        products.forEach((product, index) => {
            const prefilledMessage = `Halo, saya tertarik dengan produk ${getDisplayName(product, false)}. Apakah masih tersedia?`;
            const waLink = `https://api.whatsapp.com/send?phone=${CONFIG.adminWhatsAppNumber}&text=${encodeURIComponent(prefilledMessage)}`;

            const hasVariations = product.variations && product.variations.length > 0;
            const hasCustomAction = !!product.customAction;
            const hasSlideshow = product.slideshowImages && product.slideshowImages.length > 0;

            const priceText = hasVariations ? `Mulai ${formatPrice(product.price)}` : formatPrice(product.price);
            
            // Tentukan tombol untuk di dalam body kartu
            let bodyButtonHtml = '';
            if (hasCustomAction) {
                bodyButtonHtml = `<button class="btn ${product.customAction.class} custom-action-btn" data-id="${product.id}">${product.customAction.text}</button>`;
            } else if (hasVariations) {
                bodyButtonHtml = `<button class="btn btn-secondary select-variation-btn" data-id="${product.id}">Pilih Varian</button>`;
            }

            // Tentukan ikon overlay pada gambar
            const overlayIconHtml = (!hasVariations && !hasCustomAction)
                ? `<button class="add-to-cart-icon-btn" data-id="${product.id}" title="Tambah ke Keranjang"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></button>`
                : '';

            let imageContentHtml;
            if (hasSlideshow) {
                const shuffledImages = shuffleArray(product.slideshowImages);
                imageContentHtml = shuffledImages.map((src, idx) =>
                    `<img src="${src}" alt="${getDisplayName(product, false)} slide ${idx + 1}" class="${idx === 0 ? 'active' : ''}">`
                ).join('');
            } else {
                imageContentHtml = `<img src="${product.image}" alt="${getDisplayName(product, false)}">`;
            }

            const card = document.createElement('div');
            card.className = 'product-card';
            card.innerHTML = `
                <div class="product-image-container ${hasSlideshow ? 'mini-slideshow' : ''}">
                    ${imageContentHtml}
                    ${overlayIconHtml}
                </div>
                <div class="product-card-body">
                    <h3>${getDisplayName(product, true)}</h3>
                    <div class="price-line">
                        <span class="stock-status">In Stock</span>
                        <p class="product-price">— ${priceText}</p>
                    </div>
                    ${bodyButtonHtml}
                </div>
            `;

            // Distribusikan produk ke section yang benar
            switch (product.section) {
                case 1: productList1.appendChild(card); break;
                case 2: productList2.appendChild(card); break;
                case 3: productList3.appendChild(card); break;
                case 4: productList4.appendChild(card); break;
                default:
                    console.warn(`Produk "${product.name}" tidak memiliki section.`);
                    break;
            }
        });

        applyLayoutHacks();
        initializeMiniSlideshows();
    };

    const applyLayoutHacks = () => {
        const containers = [productList1, productList2, productList3, productList4];
        containers.forEach(container => {
            // Reset class
            container.classList.remove('layout-group-align-start');

            // Tambahkan class jika jumlah anak adalah 1 atau 4 untuk perataan khusus
            if (container.children.length === 1 || container.children.length === 4) {
                container.classList.add('layout-group-align-start');
            }
        });
    };

    const showSlide = (index) => {
        if (!slideshowTrack || slides.length === 0) return;

        if (index >= slides.length) {
            currentSlideIndex = 0;
        } else if (index < 0) {
            currentSlideIndex = slides.length - 1;
        } else {
            currentSlideIndex = index;
        }

        currentTranslate = currentSlideIndex * -slideshowTrack.clientWidth;
        setSliderPosition();

        dots.forEach(dot => dot.classList.remove('active'));
        dots[currentSlideIndex].classList.add('active');
    };

    const nextSlide = () => showSlide(currentSlideIndex + 1);
    const prevSlide = () => showSlide(currentSlideIndex - 1);

    const resetSlideInterval = () => {
        clearInterval(slideInterval);
        slideInterval = setInterval(nextSlide, 5000);
    };

    const setSliderPosition = () => {
        slideshowTrack.style.transform = `translateX(${currentTranslate}px)`;
    };

    // --- Fungsi untuk Drag & Swipe ---
    const getPositionX = (event) => {
        return event.type.includes('mouse') ? event.pageX : event.touches[0].clientX;
    };

    const dragStart = (index) => (event) => {
        isDragging = true;
        startPos = getPositionX(event);
        prevTranslate = currentTranslate;
        clearInterval(slideInterval); // Hentikan slideshow otomatis saat disentuh/diklik
        slideshowTrack.style.transition = 'none'; // Hapus transisi agar gerakan terasa real-time
    };

    const dragging = (event) => {
        if (isDragging) {
            // Cegah scrolling halaman di mobile saat swipe galeri
            if (event.type.includes('touch')) {
                event.preventDefault();
            }
            const currentPosition = getPositionX(event);
            currentTranslate = prevTranslate + currentPosition - startPos;
            setSliderPosition();
        }
    };

    const dragEnd = () => {
        isDragging = false;
        slideshowTrack.style.transition = 'transform 0.5s ease-in-out'; // Kembalikan transisi

        const movedBy = currentTranslate - prevTranslate;
        const slideWidth = slideshowTrack.clientWidth;

        // Jika geser lebih dari 15% lebar slide, pindah slide
        if (movedBy < -slideWidth * 0.15 && currentSlideIndex < slides.length - 1) {
            nextSlide();
        } else if (movedBy > slideWidth * 0.15 && currentSlideIndex > 0) {
            prevSlide();
        } else {
            // Jika tidak, kembali ke posisi slide semula
            showSlide(currentSlideIndex);
        }

        resetSlideInterval(); // Mulai lagi slideshow otomatis
    };

    const initializeMiniSlideshows = () => {
        const slideshows = document.querySelectorAll('.mini-slideshow');
        slideshows.forEach((slideshow, i) => {
            const images = slideshow.querySelectorAll('img');
            if (images.length <= 1) return;
    
            // Hentikan interval lama jika ada untuk mencegah duplikasi saat re-render
            if (slideshow.dataset.intervalId) clearInterval(parseInt(slideshow.dataset.intervalId));
    
            // Temukan gambar yang sudah 'active' dari proses render awal
            let currentIndex = Array.from(images).findIndex(img => img.classList.contains('active'));
            if (currentIndex === -1) currentIndex = 0; // Fallback jika tidak ada yang aktif
            images[currentIndex].classList.add('active'); // Pastikan ada yang aktif
    
            // Mulai interval slideshow
            const intervalId = setInterval(() => {
                if (images[currentIndex]) images[currentIndex].classList.remove('active');
                currentIndex = (currentIndex + 1) % images.length;
                if (images[currentIndex]) images[currentIndex].classList.add('active');
            }, 10000); // 10 detik

            slideshow.dataset.intervalId = intervalId;
        });
    };

    const renderGallery = () => {
        if (!gallerySection) return;

        // Hapus event listener lama jika ada (untuk hot-reloading atau re-render)
        const oldTrack = gallerySection.querySelector('.slideshow-track');
        if (oldTrack) {
            oldTrack.remove();
        }
        slides = [];
        dots = [];

        // Gunakan variabel slideshowTrack yang sudah didefinisikan di atas
        slideshowTrack = document.createElement('div');
        slideshowTrack.className = 'slideshow-track';

        const dotsContainer = gallerySection.querySelector('.slideshow-dots');
        dotsContainer.innerHTML = '';

        for (let i = 1; i <= SLIDESHOW_IMAGE_COUNT; i++) {
            const slide = document.createElement('div');
            slide.className = 'slide';
            slide.innerHTML = `<img src="images/galeri/galeri-donat-${i}.jpg" alt="Galeri Donat ${i}" loading="lazy">`;
            slideshowTrack.appendChild(slide);
            slides.push(slide);

            const dot = document.createElement('span');
            dot.className = 'dot';
            dot.addEventListener('click', () => {
                showSlide(i - 1);
                resetSlideInterval();
            });
            dotsContainer.appendChild(dot);
            dots.push(dot);
        }

        gallerySection.insertBefore(slideshowTrack, gallerySection.firstChild);

        // Tambahkan event listener untuk swipe dan drag
        slides.forEach((slide, index) => {
            // Touch events untuk mobile
            slide.addEventListener('touchstart', dragStart(index), { passive: true });
            slide.addEventListener('touchmove', dragging);
            slide.addEventListener('touchend', dragEnd);
        });

        showSlide(0);
        resetSlideInterval();
    };

    const openVariationModal = (productId) => {
        const product = products.find(p => p.id === productId);
        if (!product || !product.variations) return;

        modalProductName.innerHTML = `Pilih Varian untuk ${getDisplayName(product, true)}`;
        modalVariationsContainer.innerHTML = '';

        product.variations.forEach((variation, index) => {
            const variationId = `variation-${index}`;
            const priceDiff = variation.priceModifier > 0 ? `: <span class="price-modifier">${formatPrice(variation.priceModifier)}</span>` : '';
            const variationHtml = `
                <label for="${variationId}" class="variation-option">
                    <input type="radio" id="${variationId}" name="variation" value="${index}" ${index === 0 ? 'checked' : ''}>
                    <span>${variation.name}</span> ${priceDiff}
                </label>
            `;
            modalVariationsContainer.innerHTML += variationHtml;
        });

        // Hapus event listener lama sebelum menambahkan yang baru untuk menghindari duplikasi
        const newBtn = modalAddToCartBtn.cloneNode(true);
        modalAddToCartBtn.parentNode.replaceChild(newBtn, modalAddToCartBtn);
        modalAddToCartBtn = newBtn;

        modalAddToCartBtn.addEventListener('click', () => {
            const selectedVariationIndex = document.querySelector('input[name="variation"]:checked').value;
            const selectedVariation = product.variations[selectedVariationIndex];
            addToCart(productId, selectedVariation);
            closeVariationModal();
        });

        variationModal.classList.remove('hidden');
    };

    const closeVariationModal = () => {
        variationModal.classList.add('hidden');
    };

    const openMultiVariationModal = (productId) => {
        const product = products.find(p => p.id === productId);
        if (!product || product.variationType !== 'multi-select-qty') return;

        // State lokal untuk modal ini
        let selections = {}; // e.g., { "Cream Cheese": 2, "Coklat": 1 }

        multiModalProductName.innerHTML = `Pilih Varian untuk ${getDisplayName(product, true)}`;
        multiModalSubtitle.textContent = `Pilih varian favoritmu, total harus ${product.maxVariationQty} Pcs.`;
        multiModalMaxQty.textContent = product.maxVariationQty;
        multiModalVariationsContainer.innerHTML = '';

        const updateState = () => {
            let total = Object.values(selections).reduce((sum, qty) => sum + qty, 0);
            multiModalCurrentQty.textContent = total;

            if (total === product.maxVariationQty) {
                multiModalAddToCartBtn.disabled = false;
                multiModalAddToCartBtn.textContent = `Tambah ke Keranjang`;
            } else {
                multiModalAddToCartBtn.disabled = true;
                multiModalAddToCartBtn.textContent = `Pilih ${product.maxVariationQty} Pcs`;
            }
        };

        product.variations.forEach(variation => {
            selections[variation.name] = 0; // Inisialisasi semua kuantitas ke 0
            const optionDiv = document.createElement('div');
            optionDiv.className = 'multi-variation-option';
            optionDiv.innerHTML = `
                <span class="multi-variation-name">${variation.name}</span>
                <div class="qty-controls">
                    <button class="btn-qty" data-name="${variation.name}" data-action="decrease">-</button>
                    <span data-name="${variation.name}">${selections[variation.name]}</span>
                    <button class="btn-qty" data-name="${variation.name}" data-action="increase">+</button>
                </div>
            `;
            multiModalVariationsContainer.appendChild(optionDiv);
        });

        multiModalVariationsContainer.addEventListener('click', (e) => {
            const btn = e.target.closest('.btn-qty');
            if (!btn) return;

            const name = btn.dataset.name;
            const action = btn.dataset.action;
            let currentTotal = Object.values(selections).reduce((a, b) => a + b, 0);

            if (action === 'increase' && currentTotal < product.maxVariationQty) {
                selections[name]++;
            } else if (action === 'decrease' && selections[name] > 0) {
                selections[name]--;
            }

            multiModalVariationsContainer.querySelector(`span[data-name="${name}"]`).textContent = selections[name];
            updateState();
        });

        multiModalAddToCartBtn.onclick = () => {
            const finalSelections = Object.entries(selections).filter(([, qty]) => qty > 0).map(([name, quantity]) => ({ name, quantity }));
            addToCart(productId, finalSelections);
            closeMultiVariationModal();
        };

        updateState();
        multiVariationModal.classList.remove('hidden');
    };

    const openImageModal = (imageUrl) => {
        if (!imageModal || !imageModalSrc) return;
        imageModalSrc.src = imageUrl;
        imageModal.classList.remove('hidden');
    };

    const closeImageModal = () => {
        if (!imageModal) return;
        imageModal.classList.add('hidden');
        imageModalSrc.src = ''; // Hapus src agar tidak memuat di background
    };

    const closeMultiVariationModal = () => {
        if (multiVariationModal) {
            multiVariationModal.classList.add('hidden');
            multiModalVariationsContainer.innerHTML = ''; // Kosongkan untuk mencegah event listener ganda
        }
    };

    // --- GALLERY MODAL FUNCTIONS ---
    const showGalleryModalSlide = (index) => {
        if (!galleryModalTrack || galleryModalSlides.length === 0) return;

        if (index >= galleryModalSlides.length) {
            galleryModalCurrentIndex = 0;
        } else if (index < 0) {
            galleryModalCurrentIndex = galleryModalSlides.length - 1;
        } else {
            galleryModalCurrentIndex = index;
        }

        galleryModalCurrentTranslate = galleryModalCurrentIndex * -galleryModalTrack.clientWidth;
        galleryModalTrack.style.transform = `translateX(${galleryModalCurrentTranslate}px)`;

        galleryModalDots.forEach(dot => dot.classList.remove('active'));
        galleryModalDots[galleryModalCurrentIndex].classList.add('active');
    };

    const nextGalleryModalSlide = () => showGalleryModalSlide(galleryModalCurrentIndex + 1);
    const prevGalleryModalSlide = () => showGalleryModalSlide(galleryModalCurrentIndex - 1);

    const galleryModalGetPositionX = (event) => {
        return event.type.includes('mouse') ? event.pageX : event.touches[0].clientX;
    };

    const galleryModalDragStart = (event) => {
        galleryModalIsDragging = true;
        galleryModalStartPos = galleryModalGetPositionX(event);
        galleryModalPrevTranslate = galleryModalCurrentTranslate;
        galleryModalTrack.style.transition = 'none';
    };

    const galleryModalDragging = (event) => {
        if (galleryModalIsDragging) {
            if (event.type.includes('touch')) {
                event.preventDefault();
            }
            const currentPosition = galleryModalGetPositionX(event);
            galleryModalCurrentTranslate = galleryModalPrevTranslate + currentPosition - galleryModalStartPos;
            galleryModalTrack.style.transform = `translateX(${galleryModalCurrentTranslate}px)`;
        }
    };

    const galleryModalDragEnd = () => {
        if (!galleryModalIsDragging) return;
        galleryModalIsDragging = false;
        galleryModalTrack.style.transition = 'transform 0.5s ease-in-out';

        const movedBy = galleryModalCurrentTranslate - galleryModalPrevTranslate;
        const slideWidth = galleryModalTrack.clientWidth;

        if (movedBy < -slideWidth * 0.15 && galleryModalCurrentIndex < galleryModalSlides.length - 1) {
            nextGalleryModalSlide();
        } else if (movedBy > slideWidth * 0.15 && galleryModalCurrentIndex > 0) {
            prevGalleryModalSlide();
        } else {
            showGalleryModalSlide(galleryModalCurrentIndex);
        }
    };

    const openGalleryModal = (imageUrls) => {
        if (!galleryModal || imageUrls.length === 0) return;

        galleryModalContainer = galleryModal.querySelector('.gallery-modal-slideshow');
        galleryModalDotsContainer = galleryModal.querySelector('.slideshow-dots');
        
        galleryModalContainer.innerHTML = '';
        galleryModalDotsContainer.innerHTML = '';
        galleryModalSlides = [];
        galleryModalDots = [];

        galleryModalTrack = document.createElement('div');
        galleryModalTrack.className = 'slideshow-track';

        imageUrls.forEach((url, index) => {
            const slide = document.createElement('div');
            slide.className = 'slide';
            slide.innerHTML = `<img src="${url}" alt="Galeri Produk ${index + 1}" loading="lazy">`;
            galleryModalTrack.appendChild(slide);
            galleryModalSlides.push(slide);

            const dot = document.createElement('span');
            dot.className = 'dot';
            dot.addEventListener('click', () => showGalleryModalSlide(index));
            galleryModalDotsContainer.appendChild(dot);
            galleryModalDots.push(dot);
        });

        galleryModalContainer.appendChild(galleryModalTrack);
        showGalleryModalSlide(0);
        galleryModal.classList.remove('hidden');
    };

    const closeGalleryModal = () => {
        if (!galleryModal) return;
        galleryModal.classList.add('hidden');
        // Hapus konten untuk menghemat memori
        galleryModalContainer.innerHTML = '';
        galleryModalDotsContainer.innerHTML = '';
        galleryModalSlides = [];
        galleryModalDots = [];
        galleryModalTrack = null;
    };

    const openShareModal = () => {
        if (shareModal) shareModal.classList.remove('hidden');
    };

    const closeShareModal = () => {
        if (shareModal) shareModal.classList.add('hidden');
        if (shareModalLoading) shareModalLoading.classList.add('hidden');
    };

    const renderCartPage = () => {
        cartItemsContainer.innerHTML = '';
        if (cart.length === 0) {
            cartItemsContainer.innerHTML = '<p style="text-align: center;">Keranjang Anda masih kosong.</p>';
            checkoutButton.classList.add('hidden');
        } else {
            checkoutButton.classList.remove('hidden');
        }

        let total = 0;
        cart.forEach(item => {
            const itemTotal = item.price * item.quantity;
            total += itemTotal;

            const cartItemDiv = document.createElement('div');
            cartItemDiv.className = 'cart-item';
            cartItemDiv.innerHTML = `
                <div class="cart-item-details">
                    <strong>${getDisplayName(item, true)}</strong>
                    <br>
                    <small>${formatPrice(item.price)}</small>
                </div>
                <div class="cart-item-qty">
                    <div class="qty-controls">
                        <button class="btn-qty" data-id="${item.cartId}" data-action="decrease">-</button>
                        <span>${item.quantity}</span>
                        <button class="btn-qty" data-id="${item.cartId}" data-action="increase">+</button>
                    </div>
                </div>
                <div class="cart-item-price">
                    <strong>${formatPrice(itemTotal)}</strong>
                </div>
            `;
            cartItemsContainer.appendChild(cartItemDiv);
        });

        cartTotalEl.textContent = formatPrice(total);
    };

    const updateCartQuantity = (productId, action) => {
        const cartItem = cart.find(item => item.cartId == productId); // Gunakan '==' karena dataset.id selalu string
        if (!cartItem) return;

        if (action === 'increase') {
            cartItem.quantity++;
        } else if (action === 'decrease') {
            cartItem.quantity--;
            if (cartItem.quantity <= 0) {
                cart = cart.filter(item => item.cartId != productId);
            }
        }

        saveCart();
        renderCartPage();
    };

    const generateInvoice = (customerData, invoiceId) => {
        const invoicePage = pages.invoice;
        let itemsHtml = '';
        cart.forEach(item => {
            const itemTotal = item.price * item.quantity;
            itemsHtml += `
                <div class="invoice-item">
                    <span>${getDisplayName(item, true)} <span class="invoice-item-qty">x ${item.quantity}</span></span>
                    <span>${formatPrice(item.price * item.quantity)}</span>
                </div>
            `;
        });

        const notesHtml = customerData.notes
            ? `<hr><p><strong>Keterangan:</strong><br>${customerData.notes.replace(/\n/g, '<br>')}</p>`
            : '';

        invoicePage.innerHTML = `
            <h2>Invoice Pemesanan</h2>
            <div id="invoice-details">
                <p><strong>Nomor Invoice:</strong> ${invoiceId}</p>
                <p><strong>Nama:</strong> ${customerData.name}</p>
                <p><strong>Alamat:</strong> ${customerData.address}</p>
                <p><strong>Metode Pembayaran:</strong> ${customerData.paymentMethodFull}</p>
                <hr>
                <h3>Detail Pesanan:</h3>
                ${itemsHtml}
                <hr>
                <h3>Total Pembayaran: ${formatPrice(customerData.total)}</h3>
                ${notesHtml}
            </div>
            <p class="invoice-notice">Silakan screenshot atau klik tombol share di bawah.</p>
            <div id="invoice-actions">
                <button id="share-invoice-btn" class="btn btn-primary">Share Invoice</button>
                <button id="new-order-btn" class="btn">Buat Pesanan Baru</button>
            </div>
        `;

        const notesTextForSharing = customerData.notes ? `\nKeterangan:\n${customerData.notes}` : '';

        const invoiceTextForSharing = `
*Invoice Pemesanan - Donat DanKau*

Nomor Invoice: ${invoiceId}
Tanggal: ${new Date().toLocaleDateString('id-ID')}

*Pelanggan:*
Nama: ${customerData.name}
Alamat: ${customerData.address}

*Pesanan:*
${cart.map(item => `- ${getDisplayName(item, false)} (x${item.quantity}) = ${formatPrice(item.price * item.quantity)}`).join('\n')}
*Total: ${formatPrice(customerData.total)}*${notesTextForSharing}

Metode Pembayaran: ${customerData.paymentMethodFull}

Terima kasih telah memesan!
        `.trim();

        // Simpan data invoice saat ini untuk digunakan oleh modal share
        currentInvoiceDataForSharing = {
            element: invoicePage.querySelector('#invoice-details'),
            text: invoiceTextForSharing,
            id: invoiceId
        };

        document.getElementById('share-invoice-btn').addEventListener('click', openShareModal);
        document.getElementById('new-order-btn').addEventListener('click', () => {
            // Sekarang tombol ini hanya bertugas kembali ke katalog
            showPage('katalog');
        });

        showPage('invoice');
    };

    const shareInvoice = async (invoiceText) => {
        const shareData = {
            title: 'Invoice Pemesanan Donat DanKau',
            text: invoiceText,
        };

        if (navigator.share) {
            try {
                await navigator.share(shareData);
                console.log('Invoice berhasil dibagikan');
            } catch (err) {
                console.error('Error sharing:', err);
            }
        } else {
            alert('Fitur share tidak didukung di browser lo. Silakan screenshot invoice ini.');
        }
    };

    const submitToGoogleForm = async (customerData, invoiceId) => {
        messageContainer.innerHTML = '';
        const submissionPromises = [];

        // Buat satu promise untuk setiap item di keranjang
        for (const item of cart) {
            const itemTotal = item.price * item.quantity;
            const formDataItem = new FormData();

            // Data Pelanggan (dikirim untuk setiap baris item)
            formDataItem.append(CONFIG.googleFormEntry.customerName, customerData.name);
            formDataItem.append(CONFIG.googleFormEntry.customerAddress, customerData.address);
            formDataItem.append(CONFIG.googleFormEntry.customerPhone, customerData.phone);
            formDataItem.append(CONFIG.googleFormEntry.invoiceNumber, invoiceId);
            formDataItem.append(CONFIG.googleFormEntry.finalTotal, customerData.total);
            formDataItem.append(CONFIG.googleFormEntry.orderNotes, customerData.notes || '');

            // Data Item Spesifik
            formDataItem.append(CONFIG.googleFormEntry.donutName, getDisplayName(item, false));
            formDataItem.append(CONFIG.googleFormEntry.donutQty, item.quantity);
            formDataItem.append(CONFIG.googleFormEntry.donutPrice, item.price);
            formDataItem.append(CONFIG.googleFormEntry.donutTotal, itemTotal);

            const promise = fetch(CONFIG.googleFormUrl, {
                method: 'POST',
                body: formDataItem,
                mode: 'no-cors'
            });
            submissionPromises.push(promise);
        }

        try {
            // Jalankan semua request secara paralel
            await Promise.all(submissionPromises);
            messageContainer.innerHTML = '<p style="color: green;">✅ Data pesanan berhasil dikirim!</p>';
            return true; // Sukses
        } catch (error) {
            console.error('Gagal mengirim data ke Google Form:', error);
            messageContainer.innerHTML = '<p style="color: red;">❌ Gagal mengirim pesanan. Coba lagi atau hubungi admin ya!</p>';
            return false; // Gagal
        }
    };

    const submitTestimonialToGoogleForm = async (testimonialData) => {
        const formData = new FormData();
        formData.append(CONFIG.googleFormEntry.testiName, testimonialData.name);
        formData.append(CONFIG.googleFormEntry.testiOrderTime, testimonialData.orderTime);
        formData.append(CONFIG.googleFormEntry.testiMessage, testimonialData.message);

        try {
            await fetch(CONFIG.testimonialGoogleFormUrl, {
                method: 'POST',
                body: formData,
                mode: 'no-cors'
            });
            console.log('Testimoni berhasil dikirim ke Google Form.');
            return true;
        } catch (error) {
            console.error('Gagal mengirim testimoni ke Google Form:', error);
            alert('Gagal mengirim testimoni ke server. Namun, testimoni tetap akan dikirim via WhatsApp.');
            return false;
        }
    };

    // --- EVENT LISTENERS ---
    floatingCartLink.addEventListener('click', (e) => {
        e.preventDefault();
        renderCartPage();
        showPage('cart');
    });

    backToKatalogButton.addEventListener('click', () => showPage('katalog'));
    checkoutButton.addEventListener('click', () => showPage('checkout'));
    backToCartButton.addEventListener('click', () => showPage('cart'));

    // Event listener untuk tombol navigasi slideshow (hanya terlihat di desktop)
    gallerySection.querySelector('.prev').addEventListener('click', () => {
        prevSlide();
        resetSlideInterval();
    });
    gallerySection.querySelector('.next').addEventListener('click', () => {
        nextSlide();
        resetSlideInterval();
    });

    // Menggunakan event delegation pada parent section agar berfungsi untuk kedua list produk
    pages.katalog.addEventListener('click', (e) => {
        // Prioritas 1: Tombol tambah ke keranjang
        const cartButton = e.target.closest('.add-to-cart-icon-btn');
        if (cartButton) {
            const productId = parseInt(cartButton.dataset.id, 10);
            addToCart(productId);
            return; // Hentikan eksekusi agar modal gambar tidak ikut terbuka
        }

        // Prioritas 1.5: Tombol aksi custom (seperti "Tambahkan")
        const customActionButton = e.target.closest('.custom-action-btn');
        if (customActionButton) {
            const productId = parseInt(customActionButton.dataset.id, 10);
            addToCart(productId);
            return;
        }

        // Prioritas 2: Tombol pilih varian
        const variationButton = e.target.closest('.select-variation-btn');
        if (variationButton) {
            const productId = parseInt(variationButton.dataset.id, 10);
            const product = products.find(p => p.id === productId);
            if (product && product.variationType === 'multi-select-qty') {
                openMultiVariationModal(productId);
            } else {
                openVariationModal(productId);
            }
            return; // Hentikan eksekusi
        }

        // Prioritas 3: Klik pada gambar untuk zoom
        const imageContainer = e.target.closest('.product-image-container');        if (imageContainer) {
            // Find the product associated with this card
            const card = imageContainer.closest('.product-card');
            const buttonWithId = card.querySelector('[data-id]');
            if (!buttonWithId) return; // Should not happen if card is well-formed

            const productId = parseInt(buttonWithId.dataset.id, 10);
            const product = products.find(p => p.id === productId);

            if (product) {
                if (product.slideshowImages && product.slideshowImages.length > 0) {
                    // If product has a slideshow, open the gallery modal
                    openGalleryModal(product.slideshowImages);
                } else {
                    // Otherwise, open the simple image zoom
                    const imgElement = imageContainer.querySelector('img');
                    if (imgElement) {
                        openImageModal(imgElement.src);
                    }
                }
            }
        }
    });

    cartItemsContainer.addEventListener('click', (e) => {
        const targetButton = e.target.closest('.btn-qty');
        if (targetButton) {
            const action = targetButton.dataset.action;
            const productId = targetButton.dataset.id; // ID bisa berupa string (untuk variasi)
            updateCartQuantity(productId, action);
        }
    });

    checkoutForm.addEventListener('click', (e) => {
        const badge = e.target.closest('.account-number-badge');
        if (badge) {
            const accountNumber = badge.dataset.account;
            navigator.clipboard.writeText(accountNumber).then(() => {
                const originalText = badge.textContent;
                badge.textContent = 'Disalin!';
                setTimeout(() => {
                    badge.textContent = originalText;
                }, 1500);
            }).catch(err => {
                console.error('Gagal menyalin:', err);
                alert('Gagal menyalin nomor rekening.');
            });
        }
    });

    // Event listeners untuk menutup modal
    variationModal.querySelector('.modal-close').addEventListener('click', closeVariationModal);
    variationModal.addEventListener('click', (e) => { if (e.target === variationModal) closeVariationModal(); });

    multiVariationModal.querySelector('.modal-close').addEventListener('click', closeMultiVariationModal);
    multiVariationModal.addEventListener('click', (e) => { if (e.target === multiVariationModal) closeMultiVariationModal(); });

    // Event listeners untuk gallery modal
    if (galleryModal) {
        galleryModalCloseBtn = galleryModal.querySelector('.modal-close');
        galleryModalPrevBtn = galleryModal.querySelector('.slideshow-btn.prev');
        galleryModalNextBtn = galleryModal.querySelector('.slideshow-btn.next');

        galleryModalCloseBtn.addEventListener('click', closeGalleryModal);
        galleryModal.addEventListener('click', (e) => {
            if (e.target === galleryModal) closeGalleryModal();
        });
        galleryModalPrevBtn.addEventListener('click', prevGalleryModalSlide);
        galleryModalNextBtn.addEventListener('click', nextGalleryModalSlide);

        // Tambahkan event listener untuk swipe/drag di level dokumen agar berfungsi meski kursor keluar modal
        document.addEventListener('mousedown', (e) => { if (!galleryModal.classList.contains('hidden')) galleryModalDragStart(e); });
        document.addEventListener('touchstart', (e) => { if (!galleryModal.classList.contains('hidden')) galleryModalDragStart(e); }, { passive: true });
        document.addEventListener('mousemove', (e) => { if (!galleryModal.classList.contains('hidden')) galleryModalDragging(e); });
        document.addEventListener('touchmove', (e) => { if (!galleryModal.classList.contains('hidden')) galleryModalDragging(e); }, { passive: false });
        document.addEventListener('mouseup', () => { if (!galleryModal.classList.contains('hidden')) galleryModalDragEnd(); });
        document.addEventListener('mouseleave', () => { if (!galleryModal.classList.contains('hidden')) galleryModalDragEnd(); });
        document.addEventListener('touchend', () => { if (!galleryModal.classList.contains('hidden')) galleryModalDragEnd(); });
    }

    // Event listeners untuk modal share
    if (shareModal) {
        shareModal.querySelector('.modal-close').addEventListener('click', closeShareModal);
        shareModal.addEventListener('click', (e) => { if (e.target === shareModal) closeShareModal(); });

        shareImageBtn.addEventListener('click', async () => {
            shareModalLoading.textContent = 'Mempersiapkan gambar...';
            shareModalLoading.classList.remove('hidden');
            try {
                const canvas = await html2canvas(currentInvoiceDataForSharing.element, { scale: 2 });
                const link = document.createElement('a');
                link.download = `invoice-${currentInvoiceDataForSharing.id}.png`;
                link.href = canvas.toDataURL('image/png');
                link.click();
                closeShareModal();
            } catch (err) {
                console.error('Gagal membuat gambar:', err);
                alert('Maaf, gagal membuat file gambar.');
            } finally {
                shareModalLoading.classList.add('hidden');
            }
        });

        sharePdfBtn.addEventListener('click', async () => {
            shareModalLoading.textContent = 'Membuat PDF...';
            shareModalLoading.classList.remove('hidden');
            try {
                const { jsPDF } = window.jspdf;
                const canvas = await html2canvas(currentInvoiceDataForSharing.element, { scale: 2 });
                const imgData = canvas.toDataURL('image/jpeg', 0.9);

                const pdf = new jsPDF({ orientation: 'p', unit: 'mm', format: 'a4' });
                const pdfWidth = pdf.internal.pageSize.getWidth();
                const pdfHeight = pdf.internal.pageSize.getHeight();
                const imgProps = pdf.getImageProperties(imgData);
                const imgHeight = (imgProps.height * pdfWidth) / imgProps.width;
                let heightLeft = imgHeight > pdfHeight ? pdfHeight - 20 : imgHeight;

                pdf.addImage(imgData, 'JPEG', 10, 10, pdfWidth - 20, heightLeft);
                pdf.save(`invoice-${currentInvoiceDataForSharing.id}.pdf`);
                closeShareModal();
            } catch (err) {
                console.error('Gagal membuat PDF:', err);
                alert('Maaf, gagal membuat file PDF.');
            } finally {
                shareModalLoading.classList.add('hidden');
            }
        });

        shareWhatsappBtn.addEventListener('click', () => {
            shareInvoice(currentInvoiceDataForSharing.text);
            closeShareModal();
        });
    }

    // Event listeners untuk menutup modal gambar
    imageModal.querySelector('.modal-close').addEventListener('click', closeImageModal);
    imageModal.addEventListener('click', (e) => { if (e.target === imageModal) closeImageModal(); });

    checkoutForm.addEventListener('submit', async (e) => {
        e.preventDefault();

        const customerName = document.getElementById('customer-name').value;
        const customerAddress = document.getElementById('customer-address').value;
        const customerPhone = document.getElementById('customer-phone').value;
        const orderNotes = document.getElementById('order-notes').value;

        if (!customerName || !customerAddress || !customerPhone) {
            alert('Semua data harus diisi. Cek lagi ya!');
            return;
        }

        submitButton.disabled = true;
        submitButton.textContent = 'Memproses...';
        
        const invoiceId = `INV-${Date.now()}`;
        let total = 0;
        cart.forEach(item => { total += item.price * item.quantity; });

        const customerData = {
            name: customerName,
            address: customerAddress,
            phone: customerPhone,
            paymentMethodFull: "Transfer Bank",
            notes: orderNotes,
            total: total,
            invoiceId: invoiceId
        };
        
        const isSuccess = await submitToGoogleForm(customerData, invoiceId);
        
        if (isSuccess) {
            // Tampilkan invoice dan reset form terlebih dahulu
            generateInvoice(customerData, invoiceId); 
            checkoutForm.reset();

            // Gunakan setTimeout untuk memastikan browser selesai me-render invoice
            // sebelum kita mengosongkan keranjang dan mengupdate badge.
            setTimeout(() => {
                cart = [];
                saveCart();
            }, 0);
        } else {
            // Jika gagal, jangan reset form/tombol, biarkan pengguna mencoba lagi
            submitButton.disabled = false;
            submitButton.textContent = 'Kirim Pesanan & Buat Invoice';
        }
    });

    if (testimonialForm) {
        testimonialForm.addEventListener('submit', (e) => {
            e.preventDefault();

            const name = document.getElementById('testi-name').value.trim();
            const orderTime = document.getElementById('testi-order-time').value.trim();
            const testiMessage = document.getElementById('testi-message').value.trim();

            if (!name || !orderTime || !testiMessage) {
                alert('Harap isi semua kolom testimoni ya!');
                return;
            }

            // Kirim juga ke Google Form
            const testimonialData = { name, orderTime, message: testiMessage };
            submitTestimonialToGoogleForm(testimonialData);

            // Simpan testimoni ke localStorage
            const newTestimonial = { name, message: testiMessage };
            testimonials.push(newTestimonial);
            localStorage.setItem('testimonials', JSON.stringify(testimonials));

            // Perbarui ticker secara real-time
            renderTestimonialTicker();

            // Kirim ke WhatsApp
            const message = `
*Testimoni Baru dari Pelanggan* ❤️

*Nama:* ${name}
*Perkiraan Order:* ${orderTime}

*Pesan:*
${testiMessage}
            `.trim().replace(/\n/g, '%0A'); // Format untuk URL

            const waUrl = `https://api.whatsapp.com/send?phone=${CONFIG.testimonialWhatsAppNumber}&text=${message}`;
            window.open(waUrl, '_blank');
            testimonialForm.reset();
        });
    }

    // --- INITIALIZATION ---
    const initialize = () => {
        renderProducts();
        renderGallery();
        renderTestimonialTicker();
        updateFloatingCart();
        showPage('katalog');
    };

    initialize();
});