<?php
require_once __DIR__ . '/config/database.php';

echo '<h3>Test Database Connection</h3>';

try {
    $conn = get_db_connection();
} catch (Throwable $e) {
    echo '<p>Connection failed: ' . htmlspecialchars($e->getMessage()) . '</p>';
    exit;
}

echo '<p>Koneksi berhasil ke database: <strong>' . htmlspecialchars(DB_NAME) . '</strong></p>';

$result = $conn->query('SELECT id, username, role FROM users ORDER BY id');

if ($result && $result->num_rows > 0) {
    echo '<p><strong>Users:</strong></p>';
    echo '<ul>';
    while ($row = $result->fetch_assoc()) {
        $label = sprintf('ID: %d | %s (%s)', $row['id'], $row['username'], $row['role']);
        echo '<li>' . htmlspecialchars($label) . '</li>';
    }
    echo '</ul>';
} else {
    echo '<p>Tidak ada user di tabel users.</p>';
}

close_db_connection();
