<?php
$pageTitle = 'Manajemen Pembayaran';
$activeMenu = 'payments';
require_once __DIR__ . '/../../includes/header.php';

$db = get_db_connection();
$sql = 'SELECT p.*, c.full_name FROM payments p JOIN clients c ON c.id = p.client_id ORDER BY p.invoice_date DESC';
$result = $db->query($sql);
$payments = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
$deleteToken = csrf_token();
?>
<div class="section-header d-flex flex-wrap justify-content-between align-items-center mb-4">
    <div>
    </div>
    <div class="section-actions">
        <a href="export_pdf.php" class="btn btn-outline-secondary">Export PDF</a>
        <a href="export_excel.php" class="btn btn-outline-success">Export Excel</a>
        <a href="create.php" class="btn btn-primary"><span class="btn-label-full">Buat Invoice</span><span class="btn-label-short">Tambah</span></a>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover align-middle data-table">
        <thead>
            <tr>
                <th>Invoice</th>
                <th>Pelanggan</th>
                <th>Nominal</th>
                <th>Status</th>
                <th>Tgl Invoice</th>
                <th>Jatuh Tempo</th>
                <th>Tgl Bayar</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($payments)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted">Belum ada data pembayaran.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($payments as $payment): ?>
                    <tr>
                        <td class="fw-semibold"><?php echo htmlspecialchars($payment['invoice_number']); ?></td>
                        <td><?php echo htmlspecialchars($payment['full_name']); ?></td>
                        <td><?php echo format_currency((float) $payment['amount']); ?></td>
                        <td>
                            <span class="badge badge-status <?php echo status_badge_class($payment['payment_status']); ?>">
                                <?php echo ucfirst($payment['payment_status']); ?>
                            </span>
                        </td>
                        <td><?php echo format_date($payment['invoice_date']); ?></td>
                        <td><?php echo format_date($payment['due_date']); ?></td>
                        <td><?php echo $payment['payment_date'] ? format_date($payment['payment_date']) : '-'; ?></td>
                        <td>
                            <div class="action-buttons">
                                <a href="invoice.php?id=<?php echo $payment["id"]; ?>" 
                                   class="btn btn-sm btn-success" target="_blank" 
                                   data-bs-toggle="tooltip" title="Lihat invoice">Invoice</a>

                                <a href="edit.php?id=<?php echo $payment['id']; ?>" 
                                   class="btn btn-sm btn-primary" 
                                   data-bs-toggle="tooltip" data-bs-placement="top" 
                                   title="Edit pembayaran">Edit</a>

                                <form action="delete.php" method="POST" 
                                      onsubmit="return confirm('Hapus data pembayaran ini?');">
                                    <input type="hidden" name="id" value="<?php echo $payment['id']; ?>">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($deleteToken); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger" 
                                            data-bs-toggle="tooltip" data-bs-placement="top" 
                                            title="Hapus pembayaran">Hapus</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>

