<?php
require_once __DIR__ . '/../../includes/export_helpers.php';

require_login();
$db = get_db_connection();

$sql = 'SELECT p.invoice_number, c.full_name, p.amount, p.payment_status, p.invoice_date, p.due_date, p.payment_date FROM payments p JOIN clients c ON c.id = p.client_id ORDER BY p.invoice_date DESC';
$result = $db->query($sql);

$rows = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            $row['invoice_number'],
            $row['full_name'],
            format_currency((float) $row['amount']),
            ucfirst($row['payment_status']),
            format_date($row['invoice_date']),
            format_date($row['due_date']),
            $row['payment_date'] ? format_date($row['payment_date']) : '-',
        ];
    }
}

export_to_pdf(
    'payments',
    'Daftar Pembayaran',
    ['Invoice', 'Pelanggan', 'Nominal', 'Status', 'Tanggal Invoice', 'Jatuh Tempo', 'Tanggal Bayar'],
    $rows
);
