<?php
$pageTitle = 'Manajemen Paket';
$activeMenu = 'packages';
require_once __DIR__ . '/../../includes/header.php';

$db = get_db_connection();
$packages = [];
$result = $db->query('SELECT * FROM packages ORDER BY created_at DESC');
if ($result) {
    $packages = $result->fetch_all(MYSQLI_ASSOC);
}
$deleteToken = csrf_token();
?>
<div class="section-header d-flex flex-wrap justify-content-between align-items-center mb-4">
    <div>
    </div>
    <div class="section-actions">
        <a href="export_pdf.php" class="btn btn-outline-secondary">Export PDF</a>
        <a href="export_excel.php" class="btn btn-outline-success">Export Excel</a>
        <a href="create.php" class="btn btn-primary"><span class="btn-label-full">Tambah Paket</span><span class="btn-label-short">Tambah</span></a>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover align-middle data-table">
        <thead>
            <tr>
                <th>Nama Paket</th>
                <th>Harga</th>
                <th>Status</th>
                <th>Deskripsi</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($packages)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">Belum ada data paket.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($packages as $package): ?>
                    <tr>
                        <td class="fw-semibold"><?php echo htmlspecialchars($package['package_name']); ?></td>
                        <td><?php echo format_currency((float) $package['price']); ?></td>
                        <td><span class="badge badge-status <?php echo status_badge_class($package['status']); ?>"><?php echo ucfirst($package['status']); ?></span></td>
                        <td><?php echo nl2br(htmlspecialchars($package['description'])); ?></td>
                        <td>
                                                                                    <div class="action-buttons">
                                <a href="edit.php?id=<?php echo $package['id']; ?>" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit paket">Edit</a>
                                <form action="delete.php" method="POST" onsubmit="return confirm('Hapus paket ini?');">
                                    <input type="hidden" name="id" value="<?php echo $package['id']; ?>">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($deleteToken); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger" data-bs-toggle="tooltip" data-bs-placement="top" title="Hapus paket">Hapus</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>




