<?php
$pageTitle = 'Manajemen Pelanggan';
$activeMenu = 'clients';
require_once __DIR__ . '/../../includes/header.php';

$db = get_db_connection();
$clients = [];
$result = $db->query('SELECT * FROM clients ORDER BY created_at DESC');
if ($result) {
    $clients = $result->fetch_all(MYSQLI_ASSOC);
}
$deleteToken = csrf_token();
?>
<div class="section-header d-flex flex-wrap justify-content-between align-items-center mb-4">
    <div>
    </div>
    <div class="section-actions">
        <a href="export_pdf.php" class="btn btn-outline-secondary">Export PDF</a>
        <a href="export_excel.php" class="btn btn-outline-success">Export Excel</a>
        <a href="create.php" class="btn btn-primary"><span class="btn-label-full">Tambah Pelanggan</span><span class="btn-label-short">Tambah</span></a>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover align-middle data-table">
        <thead>
            <tr>
                <th>Kode</th>
                <th>Nama Lengkap</th>
                <th>Telepon</th>
                <th>Status</th>
                <th>Tanggal Registrasi</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($clients)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">Belum ada data pelanggan.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($clients as $client): ?>
                    <tr>
                        <td class="fw-semibold"><?php echo htmlspecialchars($client['client_code']); ?></td>
                        <td><?php echo htmlspecialchars($client['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($client['phone']); ?></td>
                        <td><span class="badge badge-status <?php echo status_badge_class($client['status']); ?>"><?php echo ucfirst($client['status']); ?></span></td>
                        <td><?php echo format_date($client['registration_date']); ?></td>
                        <td>
                                                        <div class="action-buttons">
                                <a href="edit.php?id=<?php echo $client['id']; ?>" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit pelanggan">Edit</a>
                                <form action="delete.php" method="POST" onsubmit="return confirm('Hapus pelanggan ini?');">
                                    <input type="hidden" name="id" value="<?php echo $client['id']; ?>">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($deleteToken); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger" data-bs-toggle="tooltip" data-bs-placement="top" title="Hapus pelanggan">Hapus</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>



