<?php
require_once __DIR__ . '/../../includes/export_helpers.php';

require_login();
$db = get_db_connection();

$sql = 'SELECT client_code, full_name, phone, status, registration_date FROM clients ORDER BY created_at DESC';
$result = $db->query($sql);

$rows = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            $row['client_code'],
            $row['full_name'],
            $row['phone'],
            ucfirst($row['status']),
            format_date($row['registration_date']),
        ];
    }
}

export_to_pdf(
    'clients',
    'Daftar Pelanggan',
    ['Kode', 'Nama Lengkap', 'Telepon', 'Status', 'Tanggal Registrasi'],
    $rows
);
