# Panduan Instalasi

## Prasyarat
- PHP 8.0 atau lebih baru
- MySQL 5.7 atau lebih baru
- Server web (Apache/Nginx) — disarankan menggunakan XAMPP/Laragon
- Ekstensi PHP: `mysqli`, `openssl`, `json`

## Langkah Instalasi
1. **Clone atau salin repositori** ke direktori web server (contoh: `htdocs/isp-billing`).
2. **Buat database** baru bernama `isp_billing`.
3. **Import skema & data contoh** dengan menjalankan file `sql/database.sql` melalui phpMyAdmin atau command line:
   ```bash
   mysql -u root -p isp_billing < sql/database.sql
   ```
4. **Konfigurasi koneksi database** pada `config/database.php` jika kredensial MySQL Anda berbeda dari default (`root` tanpa password).
5. **Setel izin folder** (opsional) pada direktori `uploads/` jika ingin menyimpan dokumen tambahan.
6. **Akses aplikasi** melalui browser: `http://localhost/isp-billing`.

## Akun Awal
| Role     | Username  | Password    |
|----------|-----------|-------------|
| Admin    | `admin`   | `admin123`  |
| Operator | `operator`| `operator123`|

Segera ubah password setelah login untuk keamanan.

## Troubleshooting
- Pastikan versi PHP mendukung `password_hash` dan `password_verify`.
- Jika PDF tidak dapat dibuka, pastikan MIME type tidak diblokir oleh server dan browser mendukung unduhan.
- Aktifkan `display_errors` saat pengembangan untuk membantu debugging.