<?php
$pageTitle = 'Dashboard';
$activeMenu = 'dashboard';
require_once __DIR__ . '/includes/header.php';

$summary = get_summary_cards();
$recentPayments = get_recent_payments();
$chartData = get_revenue_chart_data();
?>
<section class="metrics-section">
    <div class="row g-4">
        <div class="col-lg-6">
            <article class="card card-metric h-100">
                <header>
                    <p>Pelanggan Aktif</p>
                    <h3><?php echo number_format($summary['active_clients']); ?></h3>
                </header>
                <small class="text-muted-soft">Total pelanggan dengan status aktif.</small>
            </article>
        </div>
        <div class="col-lg-6">
            <article class="card card-metric h-100">
                <header>
                    <p>Pendapatan Bulanan</p>
                    <h3><?php echo format_currency($summary['monthly_revenue']); ?></h3>
                </header>
                <small class="text-muted-soft">Total pembayaran lunas bulan berjalan.</small>
            </article>
        </div>
        <div class="col-lg-6">
            <article class="card card-metric h-100">
                <header>
                    <p>Tagihan Pending</p>
                    <h3><?php echo number_format($summary['pending_invoices']); ?></h3>
                </header>
                <small class="text-muted-soft">Invoice yang belum dibayar.</small>
            </article>
        </div>
        <div class="col-lg-6">
            <article class="card card-metric h-100">
                <header>
                    <p>Paket Aktif</p>
                    <h3><?php echo number_format($summary['active_packages']); ?></h3>
                </header>
                <small class="text-muted-soft">Jumlah paket internet yang aktif.</small>
            </article>
        </div>
    </div>
</section>
<section class="layout-split">
    <div class="chart-card">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h2 class="h6 mb-1">Trend Pendapatan</h2>
                <small class="text-muted-soft">12 bulan terakhir</small>
            </div>
        </div>
        <canvas id="revenueChart" height="140"></canvas>
    </div>
    <aside class="card card-metric">
        <header class="mb-3">
            <h2 class="h6 mb-1">Aksi Cepat</h2>
            <p class="text-muted-soft mb-0">Kelola pelanggan, tagihan dan laporan secara instan.</p>
        </header>
        <div class="quick-actions">
            <a href="<?php echo base_url('modules/client/create.php'); ?>" class="btn btn-primary"><i class="fa-solid fa-user-plus me-2"></i>Tambah Pelanggan</a>
            <a href="<?php echo base_url('modules/payment/create.php'); ?>" class="btn btn-outline-primary"><i class="fa-solid fa-file-circle-plus me-2"></i>Buat Invoice</a>
            <a href="<?php echo base_url('modules/report_payment/index.php'); ?>" class="btn btn-outline-secondary"><i class="fa-solid fa-chart-column me-2"></i>Lihat Laporan</a>
        </div>
    </aside>
</section>
<section class="card data-card">
    <div class="section-header mb-3">
        <div>
            <h2 class="h6 mb-1">Pembayaran Terbaru</h2>
            <small class="text-muted-soft">Update terkini status pembayaran pelanggan.</small>
        </div>
        <a href="<?php echo base_url('modules/payment/index.php'); ?>" class="btn btn-outline-primary">Lihat Semua</a>
    </div>
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead>
                <tr>
                    <th>Invoice</th>
                    <th>Pelanggan</th>
                    <th>Nominal</th>
                    <th>Status</th>
                    <th>Tanggal Bayar</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($recentPayments) === 0): ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">Belum ada data pembayaran.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($recentPayments as $payment): ?>
                        <tr>
                            <td class="fw-semibold"><?php echo htmlspecialchars($payment['invoice_number']); ?></td>
                            <td><?php echo htmlspecialchars($payment['full_name']); ?></td>
                            <td><?php echo format_currency((float) $payment['amount']); ?></td>
                            <td><span class="badge badge-status <?php echo htmlspecialchars($payment['payment_status']); ?>"><?php echo ucfirst($payment['payment_status']); ?></span></td>
                            <td><?php echo $payment['payment_date'] ? format_date($payment['payment_date']) : '-'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</section>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const ctx = document.getElementById('revenueChart');
        if (!ctx) {
            return;
        }

        const labels = <?php echo json_encode($chartData['labels'], JSON_UNESCAPED_UNICODE); ?>;
        const values = <?php echo json_encode($chartData['values'], JSON_UNESCAPED_UNICODE); ?>;

        new Chart(ctx, {
            type: 'line',
            data: {
                labels,
                datasets: [{
                    label: 'Pendapatan',
                    data: values,
                    tension: 0.37,
                    borderColor: '#1b4ddb',
                    backgroundColor: 'rgba(27, 77, 219, 0.18)',
                    borderWidth: 3,
                    fill: true,
                    pointBackgroundColor: '#1238a5',
                    pointRadius: 4,
                }],
            },
            options: {
                plugins: {
                    legend: { display: false },
                },
                scales: {
                    y: { beginAtZero: true },
                },
            },
        });
    });
</script>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
