(function () {
    'use strict';

    document.addEventListener('DOMContentLoaded', function () {
        const tableSelectors = document.querySelectorAll('table.data-table');
        tableSelectors.forEach(function (table) {
            $(table).DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
                },
                pageLength: 10,
                responsive: true,
                autoWidth: false
            });
        });

        const needsValidation = document.querySelectorAll('.needs-validation');
        Array.prototype.slice.call(needsValidation).forEach(function (form) {
            form.addEventListener('submit', function (event) {
                if (!form.checkValidity()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });

        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
})();
